using System;
using Server.Network;
using Server.Items;

namespace Server.Items
{
	public class WindSong : MagicalShortbow
	{
		public override int LabelNumber{ get{ return 1075031; } } // Windsong
		
		[Constructable]
		public WindSong() : base()
		{
			Hue = 367;
			Attributes.WeaponDamage = 35;
			WeaponAttributes.SelfRepair = 3;
		}
		
		public override void GetDamageTypes( Mobile wielder, out int phys, out int fire, out int cold, out int pois, out int nrgy )
		{
			phys = fire = cold = pois = nrgy = 20;
		}

		public WindSong( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.WriteEncodedInt( 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadEncodedInt();
		}
	}
}